/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MemoryMonitor
extends JPanel {
    static JCheckBox dateStampCB = new JCheckBox("Output Date Stamp");
    public Surface surf;
    JPanel controls;
    boolean doControls;
    JTextField tf;

    public MemoryMonitor() {
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new EtchedBorder(), "Memory Monitor"));
        this.surf = new Surface();
        this.add(this.surf);
        this.controls = new JPanel();
        this.controls.setPreferredSize(new Dimension(135, 80));
        Font font = new Font("serif", 0, 10);
        JLabel label = new JLabel("Sample Rate");
        label.setFont(font);
        label.setForeground(Color.black);
        this.controls.add(label);
        this.tf = new JTextField("1000");
        this.tf.setPreferredSize(new Dimension(45, 20));
        this.controls.add(this.tf);
        label = new JLabel("ms");
        this.controls.add(label);
        label.setFont(font);
        label.setForeground(Color.black);
        this.controls.add(dateStampCB);
        dateStampCB.setFont(font);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                MemoryMonitor.this.removeAll();
                MemoryMonitor.this.doControls = !MemoryMonitor.this.doControls;
                if (MemoryMonitor.this.doControls) {
                    MemoryMonitor.this.surf.stop();
                    MemoryMonitor.this.add(MemoryMonitor.this.controls);
                } else {
                    try {
                        MemoryMonitor.this.surf.sleepAmount = Long.parseLong(MemoryMonitor.this.tf.getText().trim());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    MemoryMonitor.this.surf.start();
                    MemoryMonitor.this.add(MemoryMonitor.this.surf);
                }
                MemoryMonitor.this.validate();
                MemoryMonitor.this.repaint();
            }
        });
    }

    public static void main(String[] s) {
        final MemoryMonitor demo = new MemoryMonitor();
        final JFrame f = new JFrame("MemoryMonitor");
        WindowAdapter l = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                f.dispose();
            }

            public void windowDeiconified(WindowEvent e) {
                demo.surf.start();
            }

            public void windowIconified(WindowEvent e) {
                demo.surf.stop();
            }
        };
        f.addWindowListener(l);
        f.getContentPane().add("Center", demo);
        JButton gc = new JButton("Garbage collect");
        f.getContentPane().add((Component)gc, "South");
        gc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.out.println("calling System.gc()");
                System.gc();
            }
        });
        f.pack();
        f.setSize(new Dimension(200, 200));
        f.setVisible(true);
        demo.surf.start();
    }

    public class Surface
    extends JPanel
    implements Runnable {
        public Thread thread;
        public long sleepAmount = 1000L;
        private int w;
        private int h;
        private BufferedImage bimg;
        private Graphics2D big;
        private Font font = new Font("Times New Roman", 0, 11);
        private Runtime r = Runtime.getRuntime();
        private int columnInc;
        private int[] fUsedMemoryArr;
        private int[] fTotalMemoryArr;
        private int ptNum;
        private int ascent;
        private int descent;
        private float freeMemory;
        private float totalMemory;
        private float lastTotalMemory;
        private Rectangle graphOutlineRect = new Rectangle();
        private Rectangle2D mfRect = new Rectangle2D.Float();
        private Rectangle2D muRect = new Rectangle2D.Float();
        private Line2D graphLine = new Line2D.Float();
        private Color graphColor = new Color(46, 139, 87);
        private Color mfColor = new Color(0, 100, 0);
        private String usedStr;

        public Surface() {
            this.setBackground(Color.black);
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (Surface.this.thread == null) {
                        Surface.this.start();
                    } else {
                        Surface.this.stop();
                    }
                }
            });
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            return new Dimension(135, 80);
        }

        public void paint(Graphics g) {
            int j;
            int i;
            if (this.big == null) {
                return;
            }
            this.big.setBackground(this.getBackground());
            this.big.clearRect(0, 0, this.w, this.h);
            float freeMemory = this.r.freeMemory();
            float totalMemory = this.r.totalMemory();
            float usedMemory = totalMemory - freeMemory;
            this.big.setColor(Color.green);
            this.big.drawString(String.valueOf((int)totalMemory / 1024) + "K allocated", 4.0f, (float)this.ascent + 0.5f);
            this.usedStr = String.valueOf((int)(totalMemory - freeMemory) / 1024) + "K used";
            this.big.drawString(this.usedStr, 4, this.h - this.descent);
            float ssH = this.ascent + this.descent;
            float remainingHeight = (float)this.h - ssH * 2.0f - 0.5f;
            float blockHeight = remainingHeight / 10.0f;
            float blockWidth = 20.0f;
            float remainingWidth = (float)this.w - blockWidth - 10.0f;
            this.big.setColor(this.mfColor);
            int MemUsage = (int)(freeMemory / totalMemory * 10.0f);
            for (i = 0; i < MemUsage; ++i) {
                this.mfRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.mfRect);
            }
            this.big.setColor(Color.green);
            while (i < 10) {
                this.muRect.setRect(5.0, ssH + (float)i * blockHeight, blockWidth, blockHeight - 1.0f);
                this.big.fill(this.muRect);
                ++i;
            }
            this.big.setColor(this.graphColor);
            int graphX = 30;
            int graphY = (int)ssH;
            int graphW = this.w - graphX - 5;
            int graphH = (int)remainingHeight;
            this.graphOutlineRect.setRect(graphX, graphY, graphW, graphH);
            this.big.draw(this.graphOutlineRect);
            int graphRow = graphH / 10;
            for (int j2 = graphY; j2 <= graphH + graphY; j2 += graphRow) {
                this.graphLine.setLine(graphX, j2, graphX + graphW, j2);
                this.big.draw(this.graphLine);
            }
            int graphColumn = graphW / 15;
            if (this.columnInc == 0) {
                this.columnInc = graphColumn;
            }
            for (j = graphX + this.columnInc; j < graphW + graphX; j += graphColumn) {
                this.graphLine.setLine(j, graphY, j, graphY + graphH);
                this.big.draw(this.graphLine);
            }
            --this.columnInc;
            if (this.fUsedMemoryArr == null) {
                this.fUsedMemoryArr = new int[graphW];
                this.fTotalMemoryArr = new int[graphW];
                this.ptNum = 0;
            } else if (this.fUsedMemoryArr.length != graphW) {
                int[] tmpUsed = null;
                int[] tmpTotal = null;
                if (this.ptNum < graphW) {
                    tmpUsed = new int[this.ptNum];
                    tmpTotal = new int[this.ptNum];
                    System.arraycopy(this.fUsedMemoryArr, 0, tmpUsed, 0, tmpUsed.length);
                    System.arraycopy(this.fTotalMemoryArr, 0, tmpTotal, 0, tmpTotal.length);
                } else {
                    tmpUsed = new int[graphW];
                    tmpTotal = new int[graphW];
                    System.arraycopy(this.fUsedMemoryArr, this.fUsedMemoryArr.length - tmpUsed.length, tmpUsed, 0, tmpUsed.length);
                    System.arraycopy(this.fTotalMemoryArr, this.fTotalMemoryArr.length - tmpTotal.length, tmpTotal, 0, tmpTotal.length);
                    this.ptNum = tmpUsed.length - 2;
                }
                this.fUsedMemoryArr = new int[graphW];
                this.fTotalMemoryArr = new int[graphW];
                System.arraycopy(tmpUsed, 0, this.fUsedMemoryArr, 0, tmpUsed.length);
                System.arraycopy(tmpTotal, 0, this.fTotalMemoryArr, 0, tmpTotal.length);
            } else {
                this.fUsedMemoryArr[this.ptNum] = (int)usedMemory;
                this.fTotalMemoryArr[this.ptNum] = (int)totalMemory;
                j = graphX + graphW - this.ptNum;
                int k = 0;
                while (k < this.ptNum) {
                    if (k != 0) {
                        this.big.setColor(Color.yellow);
                        int ycur = (int)((float)graphY + (float)graphH * ((totalMemory - (float)this.fUsedMemoryArr[k]) / totalMemory));
                        int yold = (int)((float)graphY + (float)graphH * ((totalMemory - (float)this.fUsedMemoryArr[k - 1]) / totalMemory));
                        if (ycur != yold) {
                            this.big.drawLine(j - 1, yold, j, ycur);
                        } else {
                            this.big.fillRect(j, ycur, 1, 1);
                        }
                        this.big.setColor(Color.red);
                        ycur = (int)((float)graphY + (float)graphH * ((totalMemory - (float)this.fTotalMemoryArr[k]) / totalMemory));
                        yold = (int)((float)graphY + (float)graphH * ((totalMemory - (float)this.fTotalMemoryArr[k - 1]) / totalMemory));
                        if (ycur != yold) {
                            this.big.drawLine(j - 1, yold, j, ycur);
                        } else {
                            this.big.fillRect(j, ycur, 1, 1);
                        }
                    }
                    ++k;
                    ++j;
                }
                if (this.ptNum + 2 == this.fUsedMemoryArr.length) {
                    for (j = 1; j < this.fUsedMemoryArr.length; ++j) {
                        this.fUsedMemoryArr[j - 1] = this.fUsedMemoryArr[j];
                        this.fTotalMemoryArr[j - 1] = this.fTotalMemoryArr[j];
                    }
                } else {
                    ++this.ptNum;
                }
            }
            g.drawImage(this.bimg, 0, 0, this);
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setPriority(1);
            this.thread.setName("MemoryMonitor");
            this.thread.start();
        }

        public synchronized void stop() {
            this.thread = null;
            this.notify();
        }

        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me && !this.isShowing() || this.getSize().width == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            while (this.thread == me && this.isShowing()) {
                Dimension d = this.getSize();
                if (d.width != this.w || d.height != this.h) {
                    this.w = d.width;
                    this.h = d.height;
                    this.bimg = (BufferedImage)this.createImage(this.w, this.h);
                    this.big = this.bimg.createGraphics();
                    this.big.setFont(this.font);
                    FontMetrics fm = this.big.getFontMetrics(this.font);
                    this.ascent = fm.getAscent();
                    this.descent = fm.getDescent();
                }
                this.repaint();
                try {
                    Thread.sleep(this.sleepAmount);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (!dateStampCB.isSelected()) continue;
                System.out.println(new Date().toString() + " " + this.usedStr);
            }
            this.thread = null;
        }
    }
}

